# E-posta geçerlilik kontrol programı

def eposta_gecerli_mi(eposta):
    # '@' karakteri olmalı ve sadece bir tane olmalı
    if eposta.count('@') != 1:
        return False

    kullanici_adi, alan_adi = eposta.split('@')

    # Kullanıcı adı ve alan adı boş olmamalı
    if not kullanici_adi or not alan_adi:
        return False

    # Alan adında en az bir nokta olmalı
    if '.' not in alan_adi:
        return False

    # Nokta alan adının başında veya sonunda olmamalı
    if alan_adi.startswith('.') or alan_adi.endswith('.'):
        return False

    # Alan adındaki son noktanın ardından en az 2 karakter olmalı (örneğin: .com)
    son_nokta_index = alan_adi.rfind('.')
    uzanti = alan_adi[son_nokta_index+1:]
    if len(uzanti) < 2:
        return False

    return True

# Örnek kullanım
epostalar = [
    "ornek.kisi@example.com",
    "yanlis_eposta@com",
    "eksik@",
    "@eksik.com",
    "nokta.yok@alanadi",
    "yanlis@alanadi.",
    "yanlis@.alanadi.com"
]

for eposta in epostalar:
    print(f"{eposta} geçerli mi? {eposta_gecerli_mi(eposta)}")
