#include <LiquidCrystal.h>
#include <OneWire.h>
#include <DallasTemperature.h>

#define ONE_WIRE_BUS 2

OneWire oneWire(ONE_WIRE_BUS);
DallasTemperature sensors(&oneWire);

const int rs=13, rw=12,en=11,d4=10,d5=9,d6=8,d7=7;
LiquidCrystal lcd(rs, rw, en, d4, d5, d6, d7);

void setup() {
  lcd.begin(16, 2);
  sensors.begin();
  lcd.print("***TERMOMETRE***");
}

void loop() {
  sensors.requestTemperatures();
  delay(500);
  float tempC = sensors.getTempCByIndex(0);

  lcd.setCursor(0, 1);
  if (tempC != DEVICE_DISCONNECTED_C)
  {
    lcd.print("Sicaklik: ");
    lcd.print(tempC,1);
    lcd.print(" C     ");
  }
  else
  {
    lcd.println("Sensor hatasi!  ");
  }
}
