#include <LiquidCrystal.h>
#include <Keypad.h>

#define PIN_ROLE A5

const int rs=13,rw=12,en=11,d4=10,d5=9,d6=8,d7=7;
LiquidCrystal lcd(rs, rw, en, d4, d5, d6, d7);

const byte ROWS = 4; //four rows
const byte COLS = 3; //three columns
char keys[ROWS][COLS] = {
  {'1','2','3'},
  {'4','5','6'},
  {'7','8','9'},
  {'*','0','#'}
};
byte rowPins[ROWS] = {3, 2, 1, 0}; //connect to the row pinouts of the keypad
byte colPins[COLS] = {4, 5, 6}; //connect to the column pinouts of the keypad

Keypad keypad = Keypad( makeKeymap(keys), rowPins, colPins, ROWS, COLS );

long tanimli_sifre;
long girilen_sifre;
int hatali_giris_sayisi;

void setup() {
  pinMode(PIN_ROLE, OUTPUT);
  lcd.begin(16, 2);

  tanimli_sifre = 1357;
  girilen_sifre = 0;
  hatali_giris_sayisi=0;
}

void loop() {
  lcd.setCursor(0, 0);
  lcd.print(" Sifre Giriniz  ");
  lcd.setCursor(0, 1);
  char key = keypad.getKey();
  
  if (key)
  {
    if(key=='*')
    {
      girilen_sifre=0;
      lcd.clear();
    }
    else if(key=='#')
    {
      if(girilen_sifre == tanimli_sifre)
      {
        lcd.print("Sifre Dogru");
        digitalWrite(PIN_ROLE,HIGH);
        delay(1000);
        digitalWrite(PIN_ROLE,LOW);
        lcd.clear();
      }
      else // Sifre yanlis ise
      {
        lcd.print("Sifre HATALI!!");
        long say = pow(10,hatali_giris_sayisi);
        for(long i=0; i<say; i++)
        {
          delay(1000);
        }
        delay(2000);
        lcd.clear();        
        hatali_giris_sayisi++;
      }
      girilen_sifre=0;
    }
    else // sayisal tusa basildiysa
    {
      // bir basamak sola kaydirmak icin 10 ile carpariz
      girilen_sifre = girilen_sifre * 10;
      // key-48: ASCI kodundan sayisal bilgi elde edilir
      girilen_sifre = girilen_sifre + (key-48);

      //lcd.print(girilen_sifre);

      // basamak sayisi kadar * goster
      long gecici = girilen_sifre;
      while(gecici > 0)
      {
        lcd.print("*");
        gecici = gecici / 10;
      }
    }
  }
}
