#include <LiquidCrystal.h>
#include <TimerOne.h>

const int rs=12, rw=11, en=10, d4=5, d5=4, d6=3, d7=2;
LiquidCrystal lcd(rs, rw, en, d4, d5, d6, d7);

int saat, dakika, saniye;
int gun, ay, yil;

void setup() {
  lcd.begin(16, 2);
  saat=23;  dakika=59; saniye=45;
  gun=31;  ay=12;  yil=2025;
  Timer1.initialize(1000000); // saniyede bir
  Timer1.attachInterrupt(saati_calistir);  
}

/* Artık yıl kontrolü: 
   - 4'e bölünebilen yıllar artık yıldır,
   - Ancak 100'e bölünebilen yıllar artık yıl değildir,
   - Fakat 400'e bölünebilen yıllar tekrar artık yıldır.
*/
int isLeapYear(int year) {
    if (year % 400 == 0) return 1;
    if (year % 100 == 0) return 0;
    return (year % 4 == 0);
}

void saati_calistir()
{
  saniye++;
  if(saniye > 59)
  {
    saniye=0;
    dakika++;
    if(dakika > 59)
    {
      dakika=0;
      saat++;
      if(saat > 23)
      {
        saat=0;
        gun++;
        if(ay==4 || ay==6 || ay==9 || ay==11) // 30 gun
        {
          if(gun > 30)
          {
            gun=1;
            ay++;
          }
        }
        else if(ay==1 || ay==3 || ay==5 ||
                ay==7 || ay==8 || ay==10 || ay==12) // 31 gun
        {
          if(gun > 31)
          {
            gun=1;
            ay++;
          }
        }
        else // Subat
        {
          if(isLeapYear(yil) == 0)
          {
            if(gun > 28)
            {
              gun=1;
              ay++;
            }
          }
          else
          {
            if(gun > 29)
            {
              gun=1;
              ay++;
            }
          }
        }
        if(ay > 12)
        {
          ay=1;
          yil++;
        }

      }
    }
  }
}

void loop() {
  lcd.setCursor(0, 0);
  lcd.print("Saat  ");
  if(saat<10){ lcd.print("0"); }
  lcd.print(saat);
  lcd.print(":");
  if(dakika<10){ lcd.print("0"); }
  lcd.print(dakika);
  lcd.print(":");
  if(saniye<10){ lcd.print("0"); }
  lcd.print(saniye);

  lcd.setCursor(0, 1);
  lcd.print("Tarih ");
  if(gun<10){ lcd.print("0"); }
  lcd.print(gun);
  lcd.print(".");
  if(ay<10){ lcd.print("0"); }
  lcd.print(ay);
  lcd.print(".");
  lcd.print(yil);
}
